﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace v11_primer
{
    public partial class FrmOrders : Form
    {
        BindingSource bsOrders = new BindingSource();
        BindingSource bsOrderDetails = new BindingSource();
        NorthwindEntities context = new NorthwindEntities();
        int employeeID;

        public FrmOrders(int employeeID)
        {
            this.employeeID = employeeID;
            InitializeComponent();
            dgvOrders.DataSource = bsOrders;
            dgvOrderDetails.DataSource = bsOrderDetails;

            bsOrders.CurrentChanged += new EventHandler(bsOrders_CurrentChanged);
        }

        void bsOrders_CurrentChanged(object sender, EventArgs e)
        {
            if (dgvOrders.SelectedRows.Count <= 0) return;
            int orderID = (int)dgvOrders.SelectedRows[0].Cells["OrderID"].Value;
            var orderDetails = from od in context.Orders.Single(p => p.OrderID == orderID).Order_Details
                               select new
                               {
                                   od.Product.ProductName,
                                   od.UnitPrice,
                                   od.Quantity
                               };
            bsOrderDetails.DataSource = orderDetails.ToList();
        }

        private void prikaziTekuce()
        {
            var pOrders = from o in context.Orders.OfType<PendingOrder>()
                          where o.EmployeeID == employeeID
                          select new
                          {
                              o.OrderID,
                              o.Customer.CompanyName,
                              o.OrderDate
                          };
            bsOrders.DataSource = pOrders.ToList() ;
        }

        private void prikaziStare()
        {
            var oldOrders = from o in context.Orders.OfType<OldOrder>()
                          where o.EmployeeID == employeeID
                          select new
                          {
                              o.OrderID,
                              o.Customer.CompanyName,
                              o.OrderDate
                          };
            bsOrders.DataSource = oldOrders.ToList();
        }

        private void FrmOrders_Load(object sender, EventArgs e)
        {
            prikaziTekuce();
            bsOrders_CurrentChanged(null, null);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            prikaziTekuce();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            prikaziStare();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            int orderID = (int)dgvOrders.SelectedRows[0].Cells["OrderID"].Value;
            Order o = context.Orders.Single(p => p.OrderID == orderID);

            foreach (Order_Detail od in o.Order_Details)
            {
                if (od.Quantity > 5) od.Quantity = -1;
                else od.Quantity -= 1;
            }

            try
            {
                context.SaveChanges();
            }
            catch (UpdateException)
            {
                context.Refresh(System.Data.Objects.RefreshMode.StoreWins, context.Order_Details);
            }

            bsOrders_CurrentChanged(null, null);
        }
    }
}
