﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace v11_primer
{
    public partial class Form1 : Form
    {
        NorthwindEntities context;
        BindingSource bsRukovodioci = new BindingSource();

        public Form1()
        {
            InitializeComponent();
            dgvZaposleni.DataSource = bsRukovodioci;
            bsRukovodioci.CurrentChanged += new EventHandler(bsRukovodioci_CurrentChanged);
        }

        void bsRukovodioci_CurrentChanged(object sender, EventArgs e)
        {
            //try
            //{
            if (dgvZaposleni.SelectedRows.Count <= 0) return;
            int ID = (int)dgvZaposleni.SelectedRows[0].Cells["EmployeeID"].Value;
                Employee emp = context.Employees.Single(p => p.EmployeeID == ID);
                if (emp != null)
                {
                    txtIme.DataBindings.Clear();
                    txtPrezime.DataBindings.Clear();
                    txtGrad.DataBindings.Clear();
                    txtIme.DataBindings.Add("Text", emp, "FirstName");
                    txtPrezime.DataBindings.Add("Text", emp, "LastName");
                    txtGrad.DataBindings.Add("Text", emp, "City");
                }
            //}
            //catch { }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            context = new NorthwindEntities();

            prikaziRukovodioce();
        }

        private void prikaziRukovodioce()
        {
            var zaposleni = from e in context.Employees
                            select new
                            {
                                e.EmployeeID,
                                e.FirstName,
                                e.LastName,
                                e.City
                            };
            
            bsRukovodioci.DataSource = zaposleni.ToList();
        }

        private void btnSnimi_Click(object sender, EventArgs e)
        {
            bsRukovodioci.EndEdit();
            context.SaveChanges();
            prikaziRukovodioce();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (dgvZaposleni.SelectedRows.Count <= 0) return;
            int ID = (int)dgvZaposleni.SelectedRows[0].Cells["EmployeeID"].Value;

            FrmOrders frm = new FrmOrders(ID);
            frm.ShowDialog();
        }
    }
}
