﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace PABP_v7
{
    public partial class FrmProducts : Form
    {
        /// <summary>
        /// Koristimo DataSet iz prosle forme.
        /// Da bismo videli podatke vezane za samoracunajuce kolone, potrebno je da popunimo tabele odakle se povlace vrednosti sa podacima.
        /// </summary>
        DsNorthwind ds;
        DsNorthwindTableAdapters.CategoriesTableAdapter daCategories;
        DsNorthwindTableAdapters.Order_DetailsTableAdapter daOrderDetails;
        DsNorthwindTableAdapters.ProductsTableAdapter daProducts;
        public FrmProducts()
        {
            InitializeComponent();
        }
        public FrmProducts(DsNorthwind ds)
            :this()
        {
            this.ds = ds;
            daCategories = new DsNorthwindTableAdapters.CategoriesTableAdapter();
            daOrderDetails = new DsNorthwindTableAdapters.Order_DetailsTableAdapter();
            daProducts = new DsNorthwindTableAdapters.ProductsTableAdapter();
        }

        private void FrmProducts_Load(object sender, EventArgs e)
        {
            daCategories.Fill(ds.Categories);
            daOrderDetails.Fill(ds.Order_Details);
            daProducts.Fill(ds.Products);
            dgvProducts.DataSource = ds.Products;
            dgvProducts.Columns["ProductID"].Visible = false;
        }
    }
}
