﻿using Microsoft.Reporting.WinForms;
using PABP_v7.DsNorthwindTableAdapters; // da ne bismo kod adaptera pisali
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace PABP_v7
{
    public partial class Form1 : Form
    {
        /// <summary>
        /// Adapteri su nam potrebni kako bismo popunili podatke u DataSet-u.
        /// To nam je od znacaja zato sto cemo kasnije u kodu u odnosu na podatke u ove dve tabele puniti DsIzvestaj.
        /// DsIzvestaj se popunjava zapis po zapis.
        /// </summary>
        EmployeesTableAdapter daEmployees;
        OrdersTableAdapter daOrders;
        DsNorthwind ds;
        public Form1()
        {
            InitializeComponent();
            daEmployees = new EmployeesTableAdapter();
            daOrders = new OrdersTableAdapter();
            ds = new DsNorthwind();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            daEmployees.Fill(ds.Employees);
            daOrders.Fill(ds.Orders);
        }

        private void btnPrikazi_Click(object sender, EventArgs e)
        {
           // reportViewer1.LocalReport.ReportEmbeddedResource = "PABP_v7.Zaposleni.rdlc"; //moguce i na ovaj nacin povezati izvestaj i kontrolu reportviewer
            reportViewer1.LocalReport.SetParameters(
                new Microsoft.Reporting.WinForms.ReportParameter(
                    "datumOd", dtOd.Value.ToString("dd.MM.yyyy."))); //U ToString metodi vrsimo formatiranje datuma. Na taj nacin ce biti prikazan.
            reportViewer1.LocalReport.SetParameters(
                new Microsoft.Reporting.WinForms.ReportParameter
                ("datumDo", dtDo.Value.ToString("dd.MM.yyyy.")));
            this.DsIzvestaj.Zaposleni.Clear();
            foreach (DsNorthwind.EmployeesRow eRow in ds.Employees.Rows)
            {
                DataRow[] porudzbine=
                    ds.Orders.Select("EmployeeID=" + eRow.EmployeeID + "and OrderDate>=#" +
                    dtOd.Value.ToString("yyyy-MM-dd 00:00:00") +
                    "# and OrderDate<=#" + dtDo.Value.ToString("yyyy-MM-dd 00:00:00") + "#");//Za odabrane datume uzimamo redove za odredjenog zaposlenog
                DsIzvestaj.ZaposleniRow novi = this.DsIzvestaj.Zaposleni.NewZaposleniRow(); //Pravimo novi red
                novi.Ime = eRow.FirstName;
                novi.Prezime = eRow.LastName;
                novi.BrojPorucivanja = porudzbine.Length;
                this.DsIzvestaj.Zaposleni.AddZaposleniRow(novi); //Dodajemo taj red u DsIzvestaj.Sada imamo neki zapis u njemu.
            }
            this.reportViewer1.RefreshReport(); // Osvezavanje prikaza izvestaja
        }

        private void btnProducts_Click(object sender, EventArgs e)
        {
            FrmProducts frm = new FrmProducts(ds);
            frm.Show();
        }

    }
}
